-- new script file

local stWave = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("stAtt")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.attackCounter = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
      self.active = false
    end
    
    mission.enemy = Citadels.GetPlayer(3)
    self.attackPoint = Game:GetEntity('reinfTargetPoint'):GetPosition()
  end
  
  if self.active then
    if self.attackCounter > 0 then 
      UpgradeWave(self) 
	  end
    InitializeWave(self)
    GenerateWaveAI(self)
    --AttackWave(self)
    self.active = false
  end  
end

function InitializeWave(self)
  stWave['unit_L_arbalist_L1'] = self.baseCount * 0.1
  stWave['unit_L_archer_L2'] = self.baseCount * 0.08
  stWave['unit_L_fman_L2'] = self.baseCount * 0.08
  stWave['unit_L_rider_L1'] = self.baseCount * 0.04
  stWave['unit_L_catapult_L1'] = self.baseCount * 0.02
end

function UpgradeWave(self)
  self.baseCount = self.baseCount + 20
end

function GenerateWaveAI(self)
  self.attackCounter = self.attackCounter + 1
  for prefab,ammount in pairs(stWave) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(),20)
end

function OnTrigger(self, source, target)
  if target == "stAtt" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.attackCounter = ar:Read()
    self.baseCount = ar:Read()
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attackCounter)
    ar:Write(self.baseCount)
    ar:Write(self.active)
  end
end
